"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _fs = require("fs");

var _utils = require("./utils");

var _createProgram = require("./create-program");

var _createProgram2 = _interopRequireDefault(_createProgram);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @returns true iff output === input
 */
var runTsLint = function runTsLint(filepath, fix) {
  var tslint = (0, _utils.requireModule)((0, _utils.getModulePath)(filepath, "tslint"));
  var code = (0, _fs.readFileSync)(filepath, "utf8");
  var config = tslint.Configuration.findConfiguration(null, filepath).results;

  var program = (0, _createProgram2.default)(filepath);

  // TODO(azz): This actually writes over the file, we don't really want that...
  var linter = new tslint.Linter({ fix }, program);

  linter.lint(filepath, code, config);
  var result = linter.getResult();
  if (fix) {
    // There were no fixes applied
    return result.fixes.length === 0;
  } else {
    // There were no auto-fixable problems
    return !result.failures.find(function (failure) {
      return failure.fix;
    });
  }
};

exports.default = runTsLint;