"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _runTslint = require("./run-tslint");

var _runTslint2 = _interopRequireDefault(_runTslint);

var _runPrettier = require("./run-prettier");

var _runPrettier2 = _interopRequireDefault(_runPrettier);

var _createIgnorer = require("./create-ignorer");

var _createIgnorer2 = _interopRequireDefault(_createIgnorer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var check = function check(filePath) {
  var isIgnored = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : (0, _createIgnorer2.default)();

  if (isIgnored(filePath)) {
    return null;
  }
  return (0, _runPrettier2.default)(filePath, false) && (0, _runTslint2.default)(filePath, false);
};

exports.default = check;