'use strict';

var repeat = require('repeat-string');

module.exports = thematic;

/* Stringify a `thematic-break`.
 * The character used is configurable through `rule`: (`'_'`)
 *
 *     ___
 *
 * The number of repititions is defined through
 * `ruleRepetition`: (`6`)
 *
 *     ******
 *
 * Whether spaces delimit each character, is configured
 * through `ruleSpaces`: (`true`)
 *
 *     * * *
 */
function thematic() {
  var options = this.options;
  var rule = repeat(options.rule, options.ruleRepetition);
  return options.ruleSpaces ? rule.split('').join(' ') : rule;
}
