"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requireModule = requireModule;
exports.getModulePath = getModulePath;
exports.getPrettierConfig = getPrettierConfig;

var _requireRelative = require("require-relative");

var _requireRelative2 = _interopRequireDefault(_requireRelative);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function requireModule(modulePath) {
  try {
    return require(modulePath);
  } catch (error) {
    throw error;
  }
}

function getModulePath(filePath, moduleName) {
  try {
    return _requireRelative2.default.resolve(moduleName, filePath);
  } catch (error) {
    return require.resolve(moduleName);
  }
}

function getPrettierConfig(filePath) {
  var prettier = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : requireModule(getModulePath(filePath, "prettier"));

  return prettier.resolveConfig && prettier.resolveConfig.sync && prettier.resolveConfig.sync(filePath) || {};
}