"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _chalk = require("chalk");

var _chalk2 = _interopRequireDefault(_chalk);

var _yargs = require("yargs");

var _yargs2 = _interopRequireDefault(_yargs);

var _fix = require("./fix");

var _fix2 = _interopRequireDefault(_fix);

var _check = require("./check");

var _check2 = _interopRequireDefault(_check);

var _expandGlobs = require("./expand-globs");

var _expandGlobs2 = _interopRequireDefault(_expandGlobs);

var _createIgnorer = require("./create-ignorer");

var _createIgnorer2 = _interopRequireDefault(_createIgnorer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toArray(arr) { return Array.isArray(arr) ? arr : Array.from(arr); } /* eslint no-console: 0 */

var cli = function cli(argv) {
  var _yargs$command$exampl = _yargs2.default
  // Fix
  .command("fix", "Fix one or more files").example("prettier-tslint fix file1.ts file2.ts", "Fix provided files").example("prettier-tslint fix '**/*.ts'", "Fix all .ts files")
  // Check
  .command("check", "List files that aren't formatted").example("prettier-tslint check '**/*.ts'", "List unformatted .ts files")
  // Meta
  .demandCommand(1, "Command not provided.").help().parse(argv),
      _yargs$command$exampl2 = _toArray(_yargs$command$exampl._),
      command = _yargs$command$exampl2[0],
      patterns = _yargs$command$exampl2.slice(1);

  switch (command) {
    case "fix":
      return fixFiles(patterns);
    case "check":
      return checkFiles(patterns);
    default:
      (0, _yargs.showHelp)();
      console.error(`Unknown command: ${command}`);
  }
};

var fixFiles = function fixFiles(filePatterns) {
  var ignorer = (0, _createIgnorer2.default)();
  var files = (0, _expandGlobs2.default)(filePatterns);
  files.forEach(function (file) {
    var changed = !(0, _fix2.default)(file, ignorer);
    console.log(changed ? file : _chalk2.default.gray(file));
  });
};

var checkFiles = function checkFiles(filePatterns) {
  var ignorer = (0, _createIgnorer2.default)();
  var files = (0, _expandGlobs2.default)(filePatterns);
  var invalid = files.filter(function (file) {
    return !(0, _check2.default)(file, ignorer);
  });
  if (invalid.length) {
    process.exitCode = 1;
  }
  invalid.forEach(function (file) {
    return console.error(_chalk2.default.red.bold(file));
  });
};

exports.default = cli;